######## Compute indices for K-fold cross validaiton ########

# N = num options
# K = num folds, if K=-1, use leave-one-out CV
# [trainfolds{i}, testfolds{i}] = indices of i'th fold
# 
# Example:
# [trainfolds, testfolds] = Kfold(100, 3)
# testfolds{1} = 1:33, trainfolds{1} = 34:100
# testfolds{2} = 34:66, trainfolds{2} = [1:33 67:100]
# testfolds{3} = 67:100, trainfolds{3} = [1:66]
# (last fold gets all the left over so has different length)
# 
# Example
# [trainfolds, testfolds] = Kfold(100, -1)
# trainfolds{1} = 1:99, testfolds{1} = 100, etc

trainfolds <- list()
testfolds <- list()

kfold <- function(N, K) {
  if (K == -1) {
    for (i in 1:N) {
      trainfolds[[i]] <- setdiff(1:N, i)
      testfolds[[i]]  <- i
    }
  }
  
  else {
    N_seq = seq(1:N)
    ndx = 1
    for (i in 1:K) {
      lb = ndx
      ub = floor(quantile(N_seq,  i/K)) 

      testfolds[[i]]  = lb : ub
      trainfolds[[i]] = setdiff(1:N, testfolds[[i]])
      
      ndx = ub + 1
    }
  }
    
  
  return(list(a = trainfolds, b = testfolds))
  
}



